<?php
// Check if the form was submitted and the file was uploaded
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES["file"])) {
    $uploadDirectory = "files/"; // Directory to save uploaded files
    $uploadedFiles = [];

    // Loop through each uploaded file
    foreach ($_FILES["file"]["name"] as $key => $name) {
        $targetFile = $uploadDirectory . basename($name);
        
        // Attempt to move the uploaded file to the target directory
        if (move_uploaded_file($_FILES["file"]["tmp_name"][$key], $targetFile)) {
            $uploadedFile = [
                'src' => 'https://cdn.byteperks.com/uploads/' . $targetFile,
                'type' => mime_content_type($targetFile), // Get file MIME type
                'height' => getimagesize($targetFile)[1], // Get image height
                'width' => getimagesize($targetFile)[0], // Get image width
            ];

            $uploadedFiles[] = $uploadedFile;
        } else {
            // Handle failed upload
            $uploadedFiles[] = "Failed to upload $name";
        }
    }

    // Return the uploaded file data as JSON
    echo json_encode(['data' => $uploadedFiles]);
} else {
    // If no file was uploaded or the request method was not POST
    echo "Invalid request";
}
?>
