<?php
// Define the directory to scan for images
$directory = 'obs/';
$tempDirectory = 'temp/'; // Directory to temporarily store unused images

// Array of images you want to keep
$imagearr = [];

// Ensure the temp directory exists
if (!file_exists($tempDirectory)) {
    mkdir($tempDirectory, 0777, true);
}

// Scan the directory for images
$allImages = array_diff(scandir($directory), ['.', '..']);

// Find unused images
$unusedImages = array_diff($allImages, $imagearr);

// Move unused images to temp directory and then delete them
foreach ($unusedImages as $unusedImage) {
    $imagePath = $directory . $unusedImage;
    $tempPath = $tempDirectory . $unusedImage;

    if (is_file($imagePath)) {
        // Move to temp directory
        rename($imagePath, $tempPath);

        // Delete the image from the temp directory (if desired)
        // unlink($tempPath);
    }
}

echo "Unused images have been moved to the temp directory and can be deleted.";
?>
