

const loadAds = {
    init : function({div ,adtype, adPosition = null }){
        
        const allowed_adtype =  ["banner","interstitial","native","video" , "sticky"];
        if(!allowed_adtype.includes(adtype)){
            console.warn("Invalid adtype : "+adtype);
            return;
        }

        let div_element = null;
        if(document.getElementById(div)){
            div_element = document.getElementById(div);
            this.createAdDiv(div ,div_element , adtype);
        } 
        else if(document.getElementsByClassName(div)){
            div_element = document.getElementsByClassName(div);
           if(div_element.length < 1){
                console.error("Failed to load ads : \n couldnot find "+div+" div element \n Please check if you have added the div element with id "+div+" in your html file ");
                return;
           }
           for(let i = 0; i < div_element.length; i++){
            this.createAdDiv(div ,div_element[i] , adtype);
            }

        }
        else{
            console.error("Failed to load ads : \n couldnot find "+div+" div element \n Please check if you have added the div element with id "+div+" in your html file ");
            return;
        }
    },
    createAdDiv : function(div ,div_element , adtype){
        if(!div_element){
            console.error("Failed to load ads : \n couldnot find "+div+" div element \n Please check if you have added the div element with id "+div+" in your html file ");
            return;
        }
        if(adtype == "banner"){
            this.createBannerAd(div_element);
        }

        if(adtype == "interstitial"){
            this.createInterstitialAd();
        }
    },
    createBannerAd : function(div){
        const ads = [
            {
                link : "https://qr.byteperks.com",
                img : "https://cdn.byteperks.com/assets/load/qr_banner.png"
            }
        ]
        const ads_img = document.createElement("img");
        ads_img.src = ads[0].img;
        ads_img.style.width = "100%";
        ads_img.style.objectFit = "cover";
        ads_img.style.objectPosition = "center";
        ads_img.style.cursor = "pointer";
        ads_img.onclick = function(){
          window.open(ads[0].link);
        }
        div.appendChild(ads_img);
    },
    createInterstitialAd : function(){
        // create interstitial ad
        const ads_img = document.createElement("img");
        ads_img.src = "https://bimash.com.np/assets/img/games/bouncy.png";
        ads_img.style.width = "50wh";
        ads_img.style.height = "50vh";
        ads_img.style.objectFit = "cover";
        ads_img.style.objectPosition = "center";
        ads_img.style.cursor = "pointer";
        ads_img.onclick = function(){
          window.open("https://bimash.com.np");
        }
        div = document.createElement("div");
        div.style.display = "flex";
        div.style.justifyContent = "center";
        div.style.alignItems = "center";
        div.style.position = "absolute";
        div.style.top = "0";
        div.style.left = "0";
        div.style.width = "100%";
        div.style.height = "100%";
        div.style.backgroundColor = "rgba(0,0,0,0.5)";
        div.appendChild(ads_img);

        div.onclick = function(){
          div.style.display = "none";
        }

        document.body.appendChild(div);


    },
    createNativeAd : function(){
        
    },
    createVideoAd : function(){
        
    },
    createStickyAd : function(){

    },


    
}